﻿Public Class CurrentVectorViewer

    Private Const ONEDIVSQRT3 As Double = 0.57735026918962573

    Public Property Xmax() As Single
        Get
            Return xMaxValue
        End Get
        Set(ByVal value As Single)
            xMaxValue = value
        End Set
    End Property
    Private xMaxValue As Single

    Public Property Xmin() As Single
        Get
            Return xMinValue
        End Get
        Set(ByVal value As Single)
            xMinValue = value
        End Set
    End Property
    Private xMinValue As Single

    Public Property Ymax() As Single
        Get
            Return yMaxValue
        End Get
        Set(ByVal value As Single)
            yMaxValue = value
        End Set
    End Property
    Private yMaxValue As Single

    Public Property Ymin() As Single
        Get
            Return yMinValue
        End Get
        Set(ByVal value As Single)
            yMinValue = value
        End Set
    End Property
    Private yMinValue As Single

    Public Vector1 As Vector
    Public Vector2 As Vector
    Public Vector3 As Vector

    Public Alpha As Single

    Public Structure Vector
        Public Length As Single
        Public Angle As Single
    End Structure

    Dim vectorPen As New Pen(Color.Blue, 1)
    Dim fluxPen As New Pen(Color.Red, 1)
    Dim statorPen As New Pen(Color.LightGreen, 1)
    Dim axisPen As New Pen(Color.Black, 1)
    Dim greyPen As New Pen(Color.LightGray, 1)
    Dim drawFont As New Font("Arial", 12)
    Dim drawBrush As New SolidBrush(Color.Black)

    Protected Overrides Sub OnPaint(ByVal e As System.Windows.Forms.PaintEventArgs)
        MyBase.OnPaint(e)

        Dim scaleX As Single = Me.Width / (Xmax - Xmin)
        Dim scaleY As Single = Me.Height / (Ymax - Ymin)

        ' Draw horizontal axis
        e.Graphics.DrawLine(axisPen, 0, CSng(Me.Height / 2), Me.Width, CSng(Me.Height / 2))

        ' Draw vertical axis
        e.Graphics.DrawLine(axisPen, CSng(Me.Width / 2), 0, CSng(Me.Width / 2), Me.Height)

        ' Draw text
        e.Graphics.DrawString(Xmin, drawFont, drawBrush, 0, Me.Height / 2)
        e.Graphics.DrawString(Xmax, drawFont, drawBrush, Me.Width - 20, Me.Height / 2)
        e.Graphics.DrawString(Ymin, drawFont, drawBrush, Me.Width / 2 + 5, Me.Height - 20)
        e.Graphics.DrawString(Ymax, drawFont, drawBrush, Me.Width / 2 + 5, 20)

        Dim _x1 As Integer = ((Xmax - Xmin) / 2) * scaleX
        Dim _y1 As Integer = Me.Height - ((Ymax - Ymin) / 2) * scaleY
        Dim _x2 As Single = _x1 + (Vector1.Length * Math.Cos(Vector1.Angle)) * scaleX
        Dim _y2 As Single = _y1 - (Vector1.Length * Math.Sin(Vector1.Angle)) * scaleY   'Y-direction is reversed
        e.Graphics.DrawLine(vectorPen, _x1, _y1, _x2, _y2)

        _x1 = _x2
        _y1 = _y2
        _x2 = _x1 + (Vector2.Length * Math.Cos(Vector2.Angle)) * scaleX
        _y2 = _y1 - (Vector2.Length * Math.Sin(Vector2.Angle)) * scaleY   'Y-direction is reversed
        e.Graphics.DrawLine(vectorPen, _x1, _y1, _x2, _y2)


        _x1 = _x2
        _y1 = _y2
        _x2 = _x1 + (Vector3.Length * Math.Cos(Vector3.Angle)) * scaleX
        _y2 = _y1 - (Vector3.Length * Math.Sin(Vector3.Angle)) * scaleY   'Y-direction is reversed
        e.Graphics.DrawLine(vectorPen, _x1, _y1, _x2, _y2)

        _x1 = ((Xmax - Xmin) / 2) * scaleX
        _y1 = Me.Height - ((Ymax - Ymin) / 2) * scaleY
        e.Graphics.DrawLine(fluxPen, _x1, _y1, _x2, _y2)

        _x2 = _x1 + Math.Cos(Alpha) * Me.Width / 2
        _y2 = _y1 - Math.Sin(Alpha) * Me.Height / 2    'Y-direction is reversed
        e.Graphics.DrawLine(statorPen, _x1, _y1, _x2, _y2)


        e.Graphics.DrawString(Fix(Rad2Deg(Alpha)), drawFont, drawBrush, Me.Width / 2, Me.Height / 2)
        'Next
    End Sub
End Class


